/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOnDemandAuditTaskRequest extends IotRequest implements
        ToCopyableBuilder<StartOnDemandAuditTaskRequest.Builder, StartOnDemandAuditTaskRequest> {
    private final List<String> targetCheckNames;

    private StartOnDemandAuditTaskRequest(BuilderImpl builder) {
        super(builder);
        this.targetCheckNames = builder.targetCheckNames;
    }

    /**
     * <p>
     * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
     * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including
     * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Which checks are performed during the audit. The checks you specify must be enabled for your account or
     *         an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks
     *         including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks
     *         are enabled.
     */
    public List<String> targetCheckNames() {
        return targetCheckNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetCheckNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOnDemandAuditTaskRequest)) {
            return false;
        }
        StartOnDemandAuditTaskRequest other = (StartOnDemandAuditTaskRequest) obj;
        return Objects.equals(targetCheckNames(), other.targetCheckNames());
    }

    @Override
    public String toString() {
        return ToString.builder("StartOnDemandAuditTaskRequest").add("TargetCheckNames", targetCheckNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetCheckNames":
            return Optional.ofNullable(clazz.cast(targetCheckNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
        /**
         * <p>
         * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
         * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including
         * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the audit. The checks you specify must be enabled for your account
         *        or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all
         *        checks including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select
         *        which checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(Collection<String> targetCheckNames);

        /**
         * <p>
         * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
         * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including
         * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the audit. The checks you specify must be enabled for your account
         *        or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all
         *        checks including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select
         *        which checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(String... targetCheckNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOnDemandAuditTaskRequest model) {
            super(model);
            targetCheckNames(model.targetCheckNames);
        }

        public final Collection<String> getTargetCheckNames() {
            return targetCheckNames;
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String... targetCheckNames) {
            targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOnDemandAuditTaskRequest build() {
            return new StartOnDemandAuditTaskRequest(this);
        }
    }
}
