/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.StartSigningJobParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required to start a signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSigningJobParameter implements StructuredPojo,
        ToCopyableBuilder<StartSigningJobParameter.Builder, StartSigningJobParameter> {
    private final SigningProfileParameter signingProfileParameter;

    private final String signingProfileName;

    private final Destination destination;

    private StartSigningJobParameter(BuilderImpl builder) {
        this.signingProfileParameter = builder.signingProfileParameter;
        this.signingProfileName = builder.signingProfileName;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * Describes the code-signing profile.
     * </p>
     * 
     * @return Describes the code-signing profile.
     */
    public SigningProfileParameter signingProfileParameter() {
        return signingProfileParameter;
    }

    /**
     * <p>
     * The code-signing profile name.
     * </p>
     * 
     * @return The code-signing profile name.
     */
    public String signingProfileName() {
        return signingProfileName;
    }

    /**
     * <p>
     * The location to write the code-signed file.
     * </p>
     * 
     * @return The location to write the code-signed file.
     */
    public Destination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingProfileParameter());
        hashCode = 31 * hashCode + Objects.hashCode(signingProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSigningJobParameter)) {
            return false;
        }
        StartSigningJobParameter other = (StartSigningJobParameter) obj;
        return Objects.equals(signingProfileParameter(), other.signingProfileParameter())
                && Objects.equals(signingProfileName(), other.signingProfileName())
                && Objects.equals(destination(), other.destination());
    }

    @Override
    public String toString() {
        return ToString.builder("StartSigningJobParameter").add("SigningProfileParameter", signingProfileParameter())
                .add("SigningProfileName", signingProfileName()).add("Destination", destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingProfileParameter":
            return Optional.ofNullable(clazz.cast(signingProfileParameter()));
        case "signingProfileName":
            return Optional.ofNullable(clazz.cast(signingProfileName()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StartSigningJobParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StartSigningJobParameter> {
        /**
         * <p>
         * Describes the code-signing profile.
         * </p>
         * 
         * @param signingProfileParameter
         *        Describes the code-signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileParameter(SigningProfileParameter signingProfileParameter);

        /**
         * <p>
         * Describes the code-signing profile.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningProfileParameter.Builder} avoiding the
         * need to create one manually via {@link SigningProfileParameter#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningProfileParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #signingProfileParameter(SigningProfileParameter)}.
         * 
         * @param signingProfileParameter
         *        a consumer that will call methods on {@link SigningProfileParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingProfileParameter(SigningProfileParameter)
         */
        default Builder signingProfileParameter(Consumer<SigningProfileParameter.Builder> signingProfileParameter) {
            return signingProfileParameter(SigningProfileParameter.builder().applyMutation(signingProfileParameter).build());
        }

        /**
         * <p>
         * The code-signing profile name.
         * </p>
         * 
         * @param signingProfileName
         *        The code-signing profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileName(String signingProfileName);

        /**
         * <p>
         * The location to write the code-signed file.
         * </p>
         * 
         * @param destination
         *        The location to write the code-signed file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The location to write the code-signed file.
         * </p>
         * This is a convenience that creates an instance of the {@link Destination.Builder} avoiding the need to create
         * one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SigningProfileParameter signingProfileParameter;

        private String signingProfileName;

        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSigningJobParameter model) {
            signingProfileParameter(model.signingProfileParameter);
            signingProfileName(model.signingProfileName);
            destination(model.destination);
        }

        public final SigningProfileParameter.Builder getSigningProfileParameter() {
            return signingProfileParameter != null ? signingProfileParameter.toBuilder() : null;
        }

        @Override
        public final Builder signingProfileParameter(SigningProfileParameter signingProfileParameter) {
            this.signingProfileParameter = signingProfileParameter;
            return this;
        }

        public final void setSigningProfileParameter(SigningProfileParameter.BuilderImpl signingProfileParameter) {
            this.signingProfileParameter = signingProfileParameter != null ? signingProfileParameter.build() : null;
        }

        public final String getSigningProfileName() {
            return signingProfileName;
        }

        @Override
        public final Builder signingProfileName(String signingProfileName) {
            this.signingProfileName = signingProfileName;
            return this;
        }

        public final void setSigningProfileName(String signingProfileName) {
            this.signingProfileName = signingProfileName;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public StartSigningJobParameter build() {
            return new StartSigningJobParameter(this);
        }
    }
}
