/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartThingRegistrationTaskRequest extends IotRequest implements
        ToCopyableBuilder<StartThingRegistrationTaskRequest.Builder, StartThingRegistrationTaskRequest> {
    private final String templateBody;

    private final String inputFileBucket;

    private final String inputFileKey;

    private final String roleArn;

    private StartThingRegistrationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.inputFileBucket = builder.inputFileBucket;
        this.inputFileKey = builder.inputFileKey;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The provisioning template.
     * </p>
     * 
     * @return The provisioning template.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The S3 bucket that contains the input file.
     * </p>
     * 
     * @return The S3 bucket that contains the input file.
     */
    public String inputFileBucket() {
        return inputFileBucket;
    }

    /**
     * <p>
     * The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line contains
     * the parameter values to provision one device (thing).
     * </p>
     * 
     * @return The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line
     *         contains the parameter values to provision one device (thing).
     */
    public String inputFileKey() {
        return inputFileKey;
    }

    /**
     * <p>
     * The IAM role ARN that grants permission the input file.
     * </p>
     * 
     * @return The IAM role ARN that grants permission the input file.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(inputFileBucket());
        hashCode = 31 * hashCode + Objects.hashCode(inputFileKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartThingRegistrationTaskRequest)) {
            return false;
        }
        StartThingRegistrationTaskRequest other = (StartThingRegistrationTaskRequest) obj;
        return Objects.equals(templateBody(), other.templateBody()) && Objects.equals(inputFileBucket(), other.inputFileBucket())
                && Objects.equals(inputFileKey(), other.inputFileKey()) && Objects.equals(roleArn(), other.roleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("StartThingRegistrationTaskRequest").add("TemplateBody", templateBody())
                .add("InputFileBucket", inputFileBucket()).add("InputFileKey", inputFileKey()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "inputFileBucket":
            return Optional.ofNullable(clazz.cast(inputFileBucket()));
        case "inputFileKey":
            return Optional.ofNullable(clazz.cast(inputFileKey()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, StartThingRegistrationTaskRequest> {
        /**
         * <p>
         * The provisioning template.
         * </p>
         * 
         * @param templateBody
         *        The provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The S3 bucket that contains the input file.
         * </p>
         * 
         * @param inputFileBucket
         *        The S3 bucket that contains the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileBucket(String inputFileBucket);

        /**
         * <p>
         * The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line
         * contains the parameter values to provision one device (thing).
         * </p>
         * 
         * @param inputFileKey
         *        The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each
         *        line contains the parameter values to provision one device (thing).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileKey(String inputFileKey);

        /**
         * <p>
         * The IAM role ARN that grants permission the input file.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that grants permission the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String templateBody;

        private String inputFileBucket;

        private String inputFileKey;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartThingRegistrationTaskRequest model) {
            super(model);
            templateBody(model.templateBody);
            inputFileBucket(model.inputFileBucket);
            inputFileKey(model.inputFileKey);
            roleArn(model.roleArn);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getInputFileBucket() {
            return inputFileBucket;
        }

        @Override
        public final Builder inputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
            return this;
        }

        public final void setInputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
        }

        public final String getInputFileKey() {
            return inputFileKey;
        }

        @Override
        public final Builder inputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
            return this;
        }

        public final void setInputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartThingRegistrationTaskRequest build() {
            return new StartThingRegistrationTaskRequest(this);
        }
    }
}
