/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartThingRegistrationTaskResponse extends IotResponse implements
        ToCopyableBuilder<StartThingRegistrationTaskResponse.Builder, StartThingRegistrationTaskResponse> {
    private final String taskId;

    private StartThingRegistrationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The bulk thing provisioning task ID.
     * </p>
     * 
     * @return The bulk thing provisioning task ID.
     */
    public String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartThingRegistrationTaskResponse)) {
            return false;
        }
        StartThingRegistrationTaskResponse other = (StartThingRegistrationTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId());
    }

    @Override
    public String toString() {
        return ToString.builder("StartThingRegistrationTaskResponse").add("TaskId", taskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, StartThingRegistrationTaskResponse> {
        /**
         * <p>
         * The bulk thing provisioning task ID.
         * </p>
         * 
         * @param taskId
         *        The bulk thing provisioning task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartThingRegistrationTaskResponse model) {
            super(model);
            taskId(model.taskId);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public StartThingRegistrationTaskResponse build() {
            return new StartThingRegistrationTaskResponse(this);
        }
    }
}
