/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.StreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a group of files that can be streamed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stream implements StructuredPojo, ToCopyableBuilder<Stream.Builder, Stream> {
    private final String streamId;

    private final Integer fileId;

    private Stream(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.fileId = builder.fileId;
    }

    /**
     * <p>
     * The stream ID.
     * </p>
     * 
     * @return The stream ID.
     */
    public String streamId() {
        return streamId;
    }

    /**
     * <p>
     * The ID of a file associated with a stream.
     * </p>
     * 
     * @return The ID of a file associated with a stream.
     */
    public Integer fileId() {
        return fileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream) obj;
        return Objects.equals(streamId(), other.streamId()) && Objects.equals(fileId(), other.fileId());
    }

    @Override
    public String toString() {
        return ToString.builder("Stream").add("StreamId", streamId()).add("FileId", fileId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Stream> {
        /**
         * <p>
         * The stream ID.
         * </p>
         * 
         * @param streamId
         *        The stream ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * The ID of a file associated with a stream.
         * </p>
         * 
         * @param fileId
         *        The ID of a file associated with a stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(Integer fileId);
    }

    static final class BuilderImpl implements Builder {
        private String streamId;

        private Integer fileId;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            streamId(model.streamId);
            fileId(model.fileId);
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final Integer getFileId() {
            return fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        @Override
        public Stream build() {
            return new Stream(this);
        }
    }
}
