/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerResponse extends IotResponse implements
        ToCopyableBuilder<TestInvokeAuthorizerResponse.Builder, TestInvokeAuthorizerResponse> {
    private final Boolean isAuthenticated;

    private final String principalId;

    private final List<String> policyDocuments;

    private final Integer refreshAfterInSeconds;

    private final Integer disconnectAfterInSeconds;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.isAuthenticated = builder.isAuthenticated;
        this.principalId = builder.principalId;
        this.policyDocuments = builder.policyDocuments;
        this.refreshAfterInSeconds = builder.refreshAfterInSeconds;
        this.disconnectAfterInSeconds = builder.disconnectAfterInSeconds;
    }

    /**
     * <p>
     * True if the token is authenticated, otherwise false.
     * </p>
     * 
     * @return True if the token is authenticated, otherwise false.
     */
    public Boolean isAuthenticated() {
        return isAuthenticated;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @return The principal ID.
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * IAM policy documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IAM policy documents.
     */
    public List<String> policyDocuments() {
        return policyDocuments;
    }

    /**
     * <p>
     * The number of seconds after which the temporary credentials are refreshed.
     * </p>
     * 
     * @return The number of seconds after which the temporary credentials are refreshed.
     */
    public Integer refreshAfterInSeconds() {
        return refreshAfterInSeconds;
    }

    /**
     * <p>
     * The number of seconds after which the connection is terminated.
     * </p>
     * 
     * @return The number of seconds after which the connection is terminated.
     */
    public Integer disconnectAfterInSeconds() {
        return disconnectAfterInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(refreshAfterInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectAfterInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse) obj;
        return Objects.equals(isAuthenticated(), other.isAuthenticated()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(policyDocuments(), other.policyDocuments())
                && Objects.equals(refreshAfterInSeconds(), other.refreshAfterInSeconds())
                && Objects.equals(disconnectAfterInSeconds(), other.disconnectAfterInSeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerResponse").add("IsAuthenticated", isAuthenticated())
                .add("PrincipalId", principalId()).add("PolicyDocuments", policyDocuments())
                .add("RefreshAfterInSeconds", refreshAfterInSeconds())
                .add("DisconnectAfterInSeconds", disconnectAfterInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isAuthenticated":
            return Optional.ofNullable(clazz.cast(isAuthenticated()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "policyDocuments":
            return Optional.ofNullable(clazz.cast(policyDocuments()));
        case "refreshAfterInSeconds":
            return Optional.ofNullable(clazz.cast(refreshAfterInSeconds()));
        case "disconnectAfterInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectAfterInSeconds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        /**
         * <p>
         * True if the token is authenticated, otherwise false.
         * </p>
         * 
         * @param isAuthenticated
         *        True if the token is authenticated, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAuthenticated(Boolean isAuthenticated);

        /**
         * <p>
         * The principal ID.
         * </p>
         * 
         * @param principalId
         *        The principal ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * IAM policy documents.
         * </p>
         * 
         * @param policyDocuments
         *        IAM policy documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocuments(Collection<String> policyDocuments);

        /**
         * <p>
         * IAM policy documents.
         * </p>
         * 
         * @param policyDocuments
         *        IAM policy documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocuments(String... policyDocuments);

        /**
         * <p>
         * The number of seconds after which the temporary credentials are refreshed.
         * </p>
         * 
         * @param refreshAfterInSeconds
         *        The number of seconds after which the temporary credentials are refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshAfterInSeconds(Integer refreshAfterInSeconds);

        /**
         * <p>
         * The number of seconds after which the connection is terminated.
         * </p>
         * 
         * @param disconnectAfterInSeconds
         *        The number of seconds after which the connection is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Boolean isAuthenticated;

        private String principalId;

        private List<String> policyDocuments = DefaultSdkAutoConstructList.getInstance();

        private Integer refreshAfterInSeconds;

        private Integer disconnectAfterInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            isAuthenticated(model.isAuthenticated);
            principalId(model.principalId);
            policyDocuments(model.policyDocuments);
            refreshAfterInSeconds(model.refreshAfterInSeconds);
            disconnectAfterInSeconds(model.disconnectAfterInSeconds);
        }

        public final Boolean getIsAuthenticated() {
            return isAuthenticated;
        }

        @Override
        public final Builder isAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
            return this;
        }

        public final void setIsAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final Collection<String> getPolicyDocuments() {
            return policyDocuments;
        }

        @Override
        public final Builder policyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDocuments(String... policyDocuments) {
            policyDocuments(Arrays.asList(policyDocuments));
            return this;
        }

        public final void setPolicyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
        }

        public final Integer getRefreshAfterInSeconds() {
            return refreshAfterInSeconds;
        }

        @Override
        public final Builder refreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
            return this;
        }

        public final void setRefreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
        }

        public final Integer getDisconnectAfterInSeconds() {
            return disconnectAfterInSeconds;
        }

        @Override
        public final Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
            return this;
        }

        public final void setDisconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }
    }
}
