/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.transform.ThingDocumentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing search index document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingDocument implements StructuredPojo, ToCopyableBuilder<ThingDocument.Builder, ThingDocument> {
    private final String thingName;

    private final String thingId;

    private final String thingTypeName;

    private final List<String> thingGroupNames;

    private final Map<String, String> attributes;

    private final String shadow;

    private ThingDocument(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingTypeName = builder.thingTypeName;
        this.thingGroupNames = builder.thingGroupNames;
        this.attributes = builder.attributes;
        this.shadow = builder.shadow;
    }

    /**
     * <p>
     * The thing name.
     * </p>
     * 
     * @return The thing name.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The thing ID.
     * </p>
     * 
     * @return The thing ID.
     */
    public String thingId() {
        return thingId;
    }

    /**
     * <p>
     * The thing type name.
     * </p>
     * 
     * @return The thing type name.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * Thing group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Thing group names.
     */
    public List<String> thingGroupNames() {
        return thingGroupNames;
    }

    /**
     * <p>
     * The attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The shadow.
     * </p>
     * 
     * @return The shadow.
     */
    public String shadow() {
        return shadow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingId());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(shadow());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingId(), other.thingId())
                && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingGroupNames(), other.thingGroupNames()) && Objects.equals(attributes(), other.attributes())
                && Objects.equals(shadow(), other.shadow());
    }

    @Override
    public String toString() {
        return ToString.builder("ThingDocument").add("ThingName", thingName()).add("ThingId", thingId())
                .add("ThingTypeName", thingTypeName()).add("ThingGroupNames", thingGroupNames()).add("Attributes", attributes())
                .add("Shadow", shadow()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingId":
            return Optional.ofNullable(clazz.cast(thingId()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingGroupNames":
            return Optional.ofNullable(clazz.cast(thingGroupNames()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "shadow":
            return Optional.ofNullable(clazz.cast(shadow()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingDocument> {
        /**
         * <p>
         * The thing name.
         * </p>
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The thing ID.
         * </p>
         * 
         * @param thingId
         *        The thing ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingId(String thingId);

        /**
         * <p>
         * The thing type name.
         * </p>
         * 
         * @param thingTypeName
         *        The thing type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * Thing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(Collection<String> thingGroupNames);

        /**
         * <p>
         * Thing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(String... thingGroupNames);

        /**
         * <p>
         * The attributes.
         * </p>
         * 
         * @param attributes
         *        The attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The shadow.
         * </p>
         * 
         * @param shadow
         *        The shadow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadow(String shadow);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingId;

        private String thingTypeName;

        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String shadow;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingDocument model) {
            thingName(model.thingName);
            thingId(model.thingId);
            thingTypeName(model.thingTypeName);
            thingGroupNames(model.thingGroupNames);
            attributes(model.attributes);
            shadow(model.shadow);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingId() {
            return thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Collection<String> getThingGroupNames() {
            return thingGroupNames;
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String... thingGroupNames) {
            thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final String getShadow() {
            return shadow;
        }

        @Override
        public final Builder shadow(String shadow) {
            this.shadow = shadow;
            return this;
        }

        public final void setShadow(String shadow) {
            this.shadow = shadow;
        }

        @Override
        public ThingDocument build() {
            return new ThingDocument(this);
        }
    }
}
