/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ThingGroupIndexingConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing group indexing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupIndexingConfiguration implements StructuredPojo,
        ToCopyableBuilder<ThingGroupIndexingConfiguration.Builder, ThingGroupIndexingConfiguration> {
    private final String thingGroupIndexingMode;

    private ThingGroupIndexingConfiguration(BuilderImpl builder) {
        this.thingGroupIndexingMode = builder.thingGroupIndexingMode;
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public ThingGroupIndexingMode thingGroupIndexingMode() {
        return ThingGroupIndexingMode.fromValue(thingGroupIndexingMode);
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public String thingGroupIndexingModeAsString() {
        return thingGroupIndexingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupIndexingModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupIndexingConfiguration)) {
            return false;
        }
        ThingGroupIndexingConfiguration other = (ThingGroupIndexingConfiguration) obj;
        return Objects.equals(thingGroupIndexingModeAsString(), other.thingGroupIndexingModeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ThingGroupIndexingConfiguration")
                .add("ThingGroupIndexingMode", thingGroupIndexingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupIndexingMode":
            return Optional.ofNullable(clazz.cast(thingGroupIndexingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupIndexingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingGroupIndexingConfiguration> {
        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(String thingGroupIndexingMode);

        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode);
    }

    static final class BuilderImpl implements Builder {
        private String thingGroupIndexingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupIndexingConfiguration model) {
            thingGroupIndexingMode(model.thingGroupIndexingMode);
        }

        public final String getThingGroupIndexingMode() {
            return thingGroupIndexingMode;
        }

        @Override
        public final Builder thingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
            return this;
        }

        @Override
        public final Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode) {
            this.thingGroupIndexingMode(thingGroupIndexingMode.toString());
            return this;
        }

        public final void setThingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
        }

        @Override
        public ThingGroupIndexingConfiguration build() {
            return new ThingGroupIndexingConfiguration(this);
        }
    }
}
