/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ThingIndexingConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing indexing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingIndexingConfiguration implements StructuredPojo,
        ToCopyableBuilder<ThingIndexingConfiguration.Builder, ThingIndexingConfiguration> {
    private final String thingIndexingMode;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index will contain only registry data.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index will contain only registry data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(thingIndexingMode);
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index will contain only registry data.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index will contain only registry data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public String thingIndexingModeAsString() {
        return thingIndexingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration) obj;
        return Objects.equals(thingIndexingModeAsString(), other.thingIndexingModeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ThingIndexingConfiguration").add("ThingIndexingMode", thingIndexingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingMode":
            return Optional.ofNullable(clazz.cast(thingIndexingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingIndexingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingIndexingConfiguration> {
        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index will contain only registry data.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index will contain only registry data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(String thingIndexingMode);

        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index will contain only registry data.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index will contain only registry data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index will contain registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(ThingIndexingMode thingIndexingMode);
    }

    static final class BuilderImpl implements Builder {
        private String thingIndexingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            thingIndexingMode(model.thingIndexingMode);
        }

        public final String getThingIndexingMode() {
            return thingIndexingMode;
        }

        @Override
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode.toString());
            return this;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        @Override
        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }
    }
}
