/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexingConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateIndexingConfigurationRequest.Builder, UpdateIndexingConfigurationRequest> {
    private final ThingIndexingConfiguration thingIndexingConfiguration;

    private final ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

    private UpdateIndexingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.thingIndexingConfiguration = builder.thingIndexingConfiguration;
        this.thingGroupIndexingConfiguration = builder.thingGroupIndexingConfiguration;
    }

    /**
     * <p>
     * Thing indexing configuration.
     * </p>
     * 
     * @return Thing indexing configuration.
     */
    public ThingIndexingConfiguration thingIndexingConfiguration() {
        return thingIndexingConfiguration;
    }

    /**
     * <p>
     * Thing group indexing configuration.
     * </p>
     * 
     * @return Thing group indexing configuration.
     */
    public ThingGroupIndexingConfiguration thingGroupIndexingConfiguration() {
        return thingGroupIndexingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupIndexingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexingConfigurationRequest)) {
            return false;
        }
        UpdateIndexingConfigurationRequest other = (UpdateIndexingConfigurationRequest) obj;
        return Objects.equals(thingIndexingConfiguration(), other.thingIndexingConfiguration())
                && Objects.equals(thingGroupIndexingConfiguration(), other.thingGroupIndexingConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateIndexingConfigurationRequest")
                .add("ThingIndexingConfiguration", thingIndexingConfiguration())
                .add("ThingGroupIndexingConfiguration", thingGroupIndexingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingConfiguration":
            return Optional.ofNullable(clazz.cast(thingIndexingConfiguration()));
        case "thingGroupIndexingConfiguration":
            return Optional.ofNullable(clazz.cast(thingGroupIndexingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, UpdateIndexingConfigurationRequest> {
        /**
         * <p>
         * Thing indexing configuration.
         * </p>
         * 
         * @param thingIndexingConfiguration
         *        Thing indexing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration);

        /**
         * <p>
         * Thing indexing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingIndexingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ThingIndexingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingIndexingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #thingIndexingConfiguration(ThingIndexingConfiguration)}.
         * 
         * @param thingIndexingConfiguration
         *        a consumer that will call methods on {@link ThingIndexingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingIndexingConfiguration(ThingIndexingConfiguration)
         */
        default Builder thingIndexingConfiguration(Consumer<ThingIndexingConfiguration.Builder> thingIndexingConfiguration) {
            return thingIndexingConfiguration(ThingIndexingConfiguration.builder().applyMutation(thingIndexingConfiguration)
                    .build());
        }

        /**
         * <p>
         * Thing group indexing configuration.
         * </p>
         * 
         * @param thingGroupIndexingConfiguration
         *        Thing group indexing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration);

        /**
         * <p>
         * Thing group indexing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupIndexingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ThingGroupIndexingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupIndexingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration)}.
         * 
         * @param thingGroupIndexingConfiguration
         *        a consumer that will call methods on {@link ThingGroupIndexingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration)
         */
        default Builder thingGroupIndexingConfiguration(
                Consumer<ThingGroupIndexingConfiguration.Builder> thingGroupIndexingConfiguration) {
            return thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration.builder()
                    .applyMutation(thingGroupIndexingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private ThingIndexingConfiguration thingIndexingConfiguration;

        private ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexingConfigurationRequest model) {
            super(model);
            thingIndexingConfiguration(model.thingIndexingConfiguration);
            thingGroupIndexingConfiguration(model.thingGroupIndexingConfiguration);
        }

        public final ThingIndexingConfiguration.Builder getThingIndexingConfiguration() {
            return thingIndexingConfiguration != null ? thingIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration;
            return this;
        }

        public final void setThingIndexingConfiguration(ThingIndexingConfiguration.BuilderImpl thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration != null ? thingIndexingConfiguration.build() : null;
        }

        public final ThingGroupIndexingConfiguration.Builder getThingGroupIndexingConfiguration() {
            return thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration;
            return this;
        }

        public final void setThingGroupIndexingConfiguration(
                ThingGroupIndexingConfiguration.BuilderImpl thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration
                    .build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexingConfigurationRequest build() {
            return new UpdateIndexingConfigurationRequest(this);
        }
    }
}
