/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScheduledAuditRequest extends IotRequest implements
        ToCopyableBuilder<UpdateScheduledAuditRequest.Builder, UpdateScheduledAuditRequest> {
    private final String frequency;

    private final String dayOfMonth;

    private final String dayOfWeek;

    private final List<String> targetCheckNames;

    private final String scheduledAuditName;

    private UpdateScheduledAuditRequest(BuilderImpl builder) {
        super(builder);
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.targetCheckNames = builder.targetCheckNames;
        this.scheduledAuditName = builder.scheduledAuditName;
    }

    /**
     * <p>
     * How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The actual
     * start time of each audit is determined by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The
     *         actual start time of each audit is determined by the system.
     * @see AuditFrequency
     */
    public AuditFrequency frequency() {
        return AuditFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The actual
     * start time of each audit is determined by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The
     *         actual start time of each audit is determined by the system.
     * @see AuditFrequency
     */
    public String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This field is
     * required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and the month does not
     * have that many days, the audit takes place on the "LAST" day of the month.
     * </p>
     * 
     * @return The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This
     *         field is required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and the
     *         month does not have that many days, the audit takes place on the "LAST" day of the month.
     */
    public String dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED", "THU",
     * "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED",
     *         "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or
     *         "BIWEEKLY".
     * @see DayOfWeek
     */
    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED", "THU",
     * "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED",
     *         "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or
     *         "BIWEEKLY".
     * @see DayOfWeek
     */
    public String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * <p>
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
     * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are enabled or
     * <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
     *         <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are
     *         enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
     */
    public List<String> targetCheckNames() {
        return targetCheckNames;
    }

    /**
     * <p>
     * The name of the scheduled audit. (Max. 128 chars)
     * </p>
     * 
     * @return The name of the scheduled audit. (Max. 128 chars)
     */
    public String scheduledAuditName() {
        return scheduledAuditName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetCheckNames());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledAuditRequest)) {
            return false;
        }
        UpdateScheduledAuditRequest other = (UpdateScheduledAuditRequest) obj;
        return Objects.equals(frequencyAsString(), other.frequencyAsString()) && Objects.equals(dayOfMonth(), other.dayOfMonth())
                && Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString())
                && Objects.equals(targetCheckNames(), other.targetCheckNames())
                && Objects.equals(scheduledAuditName(), other.scheduledAuditName());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateScheduledAuditRequest").add("Frequency", frequencyAsString())
                .add("DayOfMonth", dayOfMonth()).add("DayOfWeek", dayOfWeekAsString())
                .add("TargetCheckNames", targetCheckNames()).add("ScheduledAuditName", scheduledAuditName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "dayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "dayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "targetCheckNames":
            return Optional.ofNullable(clazz.cast(targetCheckNames()));
        case "scheduledAuditName":
            return Optional.ofNullable(clazz.cast(scheduledAuditName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, UpdateScheduledAuditRequest> {
        /**
         * <p>
         * How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The
         * actual start time of each audit is determined by the system.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY".
         *        The actual start time of each audit is determined by the system.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The
         * actual start time of each audit is determined by the system.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY".
         *        The actual start time of each audit is determined by the system.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(AuditFrequency frequency);

        /**
         * <p>
         * The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This field
         * is required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and the month does
         * not have that many days, the audit takes place on the "LAST" day of the month.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This
         *        field is required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and
         *        the month does not have that many days, the audit takes place on the "LAST" day of the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(String dayOfMonth);

        /**
         * <p>
         * The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED",
         * "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE",
         *        "WED", "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY"
         *        or "BIWEEKLY".
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED",
         * "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE",
         *        "WED", "THU", "FRI" or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY"
         *        or "BIWEEKLY".
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * <p>
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are enabled
         * or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         *        <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are
         *        enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(Collection<String> targetCheckNames);

        /**
         * <p>
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are enabled
         * or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         *        <code>DescribeAccountAuditConfiguration</code> to see the list of all checks including those that are
         *        enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(String... targetCheckNames);

        /**
         * <p>
         * The name of the scheduled audit. (Max. 128 chars)
         * </p>
         * 
         * @param scheduledAuditName
         *        The name of the scheduled audit. (Max. 128 chars)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditName(String scheduledAuditName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String frequency;

        private String dayOfMonth;

        private String dayOfWeek;

        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private String scheduledAuditName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledAuditRequest model) {
            super(model);
            frequency(model.frequency);
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
            targetCheckNames(model.targetCheckNames);
            scheduledAuditName(model.scheduledAuditName);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getDayOfMonth() {
            return dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public final Collection<String> getTargetCheckNames() {
            return targetCheckNames;
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String... targetCheckNames) {
            targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        public final String getScheduledAuditName() {
            return scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduledAuditRequest build() {
            return new UpdateScheduledAuditRequest(this);
        }
    }
}
