/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScheduledAuditResponse extends IotResponse implements
        ToCopyableBuilder<UpdateScheduledAuditResponse.Builder, UpdateScheduledAuditResponse> {
    private final String scheduledAuditArn;

    private UpdateScheduledAuditResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAuditArn = builder.scheduledAuditArn;
    }

    /**
     * <p>
     * The ARN of the scheduled audit.
     * </p>
     * 
     * @return The ARN of the scheduled audit.
     */
    public String scheduledAuditArn() {
        return scheduledAuditArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledAuditResponse)) {
            return false;
        }
        UpdateScheduledAuditResponse other = (UpdateScheduledAuditResponse) obj;
        return Objects.equals(scheduledAuditArn(), other.scheduledAuditArn());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateScheduledAuditResponse").add("ScheduledAuditArn", scheduledAuditArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAuditArn":
            return Optional.ofNullable(clazz.cast(scheduledAuditArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, UpdateScheduledAuditResponse> {
        /**
         * <p>
         * The ARN of the scheduled audit.
         * </p>
         * 
         * @param scheduledAuditArn
         *        The ARN of the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditArn(String scheduledAuditArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String scheduledAuditArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledAuditResponse model) {
            super(model);
            scheduledAuditArn(model.scheduledAuditArn);
        }

        public final String getScheduledAuditArn() {
            return scheduledAuditArn;
        }

        @Override
        public final Builder scheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        public final void setScheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
        }

        @Override
        public UpdateScheduledAuditResponse build() {
            return new UpdateScheduledAuditResponse(this);
        }
    }
}
