/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThingGroupsForThingRequest extends IotRequest implements
        ToCopyableBuilder<UpdateThingGroupsForThingRequest.Builder, UpdateThingGroupsForThingRequest> {
    private final String thingName;

    private final List<String> thingGroupsToAdd;

    private final List<String> thingGroupsToRemove;

    private UpdateThingGroupsForThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingGroupsToAdd = builder.thingGroupsToAdd;
        this.thingGroupsToRemove = builder.thingGroupsToRemove;
    }

    /**
     * <p>
     * The thing whose group memberships will be updated.
     * </p>
     * 
     * @return The thing whose group memberships will be updated.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The groups to which the thing will be added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The groups to which the thing will be added.
     */
    public List<String> thingGroupsToAdd() {
        return thingGroupsToAdd;
    }

    /**
     * <p>
     * The groups from which the thing will be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The groups from which the thing will be removed.
     */
    public List<String> thingGroupsToRemove() {
        return thingGroupsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupsToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupsToRemove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingGroupsForThingRequest)) {
            return false;
        }
        UpdateThingGroupsForThingRequest other = (UpdateThingGroupsForThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingGroupsToAdd(), other.thingGroupsToAdd())
                && Objects.equals(thingGroupsToRemove(), other.thingGroupsToRemove());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateThingGroupsForThingRequest").add("ThingName", thingName())
                .add("ThingGroupsToAdd", thingGroupsToAdd()).add("ThingGroupsToRemove", thingGroupsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingGroupsToAdd":
            return Optional.ofNullable(clazz.cast(thingGroupsToAdd()));
        case "thingGroupsToRemove":
            return Optional.ofNullable(clazz.cast(thingGroupsToRemove()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
        /**
         * <p>
         * The thing whose group memberships will be updated.
         * </p>
         * 
         * @param thingName
         *        The thing whose group memberships will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The groups to which the thing will be added.
         * </p>
         * 
         * @param thingGroupsToAdd
         *        The groups to which the thing will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd);

        /**
         * <p>
         * The groups to which the thing will be added.
         * </p>
         * 
         * @param thingGroupsToAdd
         *        The groups to which the thing will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToAdd(String... thingGroupsToAdd);

        /**
         * <p>
         * The groups from which the thing will be removed.
         * </p>
         * 
         * @param thingGroupsToRemove
         *        The groups from which the thing will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove);

        /**
         * <p>
         * The groups from which the thing will be removed.
         * </p>
         * 
         * @param thingGroupsToRemove
         *        The groups from which the thing will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToRemove(String... thingGroupsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private List<String> thingGroupsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> thingGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingGroupsForThingRequest model) {
            super(model);
            thingName(model.thingName);
            thingGroupsToAdd(model.thingGroupsToAdd);
            thingGroupsToRemove(model.thingGroupsToRemove);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Collection<String> getThingGroupsToAdd() {
            return thingGroupsToAdd;
        }

        @Override
        public final Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToAdd(String... thingGroupsToAdd) {
            thingGroupsToAdd(Arrays.asList(thingGroupsToAdd));
            return this;
        }

        public final void setThingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
        }

        public final Collection<String> getThingGroupsToRemove() {
            return thingGroupsToRemove;
        }

        @Override
        public final Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToRemove(String... thingGroupsToRemove) {
            thingGroupsToRemove(Arrays.asList(thingGroupsToRemove));
            return this;
        }

        public final void setThingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingGroupsForThingRequest build() {
            return new UpdateThingGroupsForThingRequest(this);
        }
    }
}
