/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ActiveViolation;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ActiveViolation} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ActiveViolationMarshaller {
    private static final MarshallingInfo<String> VIOLATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationId").isBinary(false).build();

    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();

    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behavior").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LASTVIOLATIONVALUE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lastViolationValue").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTVIOLATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastViolationTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> VIOLATIONSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationStartTime").isBinary(false).build();

    private static final ActiveViolationMarshaller INSTANCE = new ActiveViolationMarshaller();

    private ActiveViolationMarshaller() {
    }

    public static ActiveViolationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ActiveViolation activeViolation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(activeViolation, "activeViolation");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(activeViolation.violationId(), VIOLATIONID_BINDING);
            protocolMarshaller.marshall(activeViolation.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall(activeViolation.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall(activeViolation.behavior(), BEHAVIOR_BINDING);
            protocolMarshaller.marshall(activeViolation.lastViolationValue(), LASTVIOLATIONVALUE_BINDING);
            protocolMarshaller.marshall(activeViolation.lastViolationTime(), LASTVIOLATIONTIME_BINDING);
            protocolMarshaller.marshall(activeViolation.violationStartTime(), VIOLATIONSTARTTIME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
