/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AddThingToThingGroupRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AddThingToThingGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> THINGGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupName").isBinary(false).build();

    private static final MarshallingInfo<String> THINGGROUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupArn").isBinary(false).build();

    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();

    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingArn").isBinary(false).build();

    private static final AddThingToThingGroupRequestModelMarshaller INSTANCE = new AddThingToThingGroupRequestModelMarshaller();

    private AddThingToThingGroupRequestModelMarshaller() {
    }

    public static AddThingToThingGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AddThingToThingGroupRequest addThingToThingGroupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(addThingToThingGroupRequest, "addThingToThingGroupRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(addThingToThingGroupRequest.thingGroupName(), THINGGROUPNAME_BINDING);
            protocolMarshaller.marshall(addThingToThingGroupRequest.thingGroupArn(), THINGGROUPARN_BINDING);
            protocolMarshaller.marshall(addThingToThingGroupRequest.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall(addThingToThingGroupRequest.thingArn(), THINGARN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
