/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuditCheckDetails;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AuditCheckDetails} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AuditCheckDetailsMarshaller {
    private static final MarshallingInfo<String> CHECKRUNSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkRunStatus").isBinary(false).build();

    private static final MarshallingInfo<Boolean> CHECKCOMPLIANT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkCompliant").isBinary(false).build();

    private static final MarshallingInfo<Long> TOTALRESOURCESCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalResourcesCount").isBinary(false).build();

    private static final MarshallingInfo<Long> NONCOMPLIANTRESOURCESCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantResourcesCount").isBinary(false)
            .build();

    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();

    private static final AuditCheckDetailsMarshaller INSTANCE = new AuditCheckDetailsMarshaller();

    private AuditCheckDetailsMarshaller() {
    }

    public static AuditCheckDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AuditCheckDetails auditCheckDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(auditCheckDetails, "auditCheckDetails");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(auditCheckDetails.checkRunStatusAsString(), CHECKRUNSTATUS_BINDING);
            protocolMarshaller.marshall(auditCheckDetails.checkCompliant(), CHECKCOMPLIANT_BINDING);
            protocolMarshaller.marshall(auditCheckDetails.totalResourcesCount(), TOTALRESOURCESCOUNT_BINDING);
            protocolMarshaller.marshall(auditCheckDetails.nonCompliantResourcesCount(), NONCOMPLIANTRESOURCESCOUNT_BINDING);
            protocolMarshaller.marshall(auditCheckDetails.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall(auditCheckDetails.message(), MESSAGE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
