/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuditFinding;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AuditFinding} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AuditFindingMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();

    private static final MarshallingInfo<String> CHECKNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkName").isBinary(false).build();

    private static final MarshallingInfo<Instant> TASKSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskStartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> FINDINGTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingTime").isBinary(false).build();

    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severity").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTRESOURCE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("nonCompliantResource").isBinary(false).build();

    private static final MarshallingInfo<List> RELATEDRESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedResources").isBinary(false).build();

    private static final MarshallingInfo<String> REASONFORNONCOMPLIANCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reasonForNonCompliance").isBinary(false).build();

    private static final MarshallingInfo<String> REASONFORNONCOMPLIANCECODE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("reasonForNonComplianceCode").isBinary(false).build();

    private static final AuditFindingMarshaller INSTANCE = new AuditFindingMarshaller();

    private AuditFindingMarshaller() {
    }

    public static AuditFindingMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AuditFinding auditFinding, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(auditFinding, "auditFinding");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(auditFinding.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall(auditFinding.checkName(), CHECKNAME_BINDING);
            protocolMarshaller.marshall(auditFinding.taskStartTime(), TASKSTARTTIME_BINDING);
            protocolMarshaller.marshall(auditFinding.findingTime(), FINDINGTIME_BINDING);
            protocolMarshaller.marshall(auditFinding.severityAsString(), SEVERITY_BINDING);
            protocolMarshaller.marshall(auditFinding.nonCompliantResource(), NONCOMPLIANTRESOURCE_BINDING);
            protocolMarshaller.marshall(auditFinding.relatedResources(), RELATEDRESOURCES_BINDING);
            protocolMarshaller.marshall(auditFinding.reasonForNonCompliance(), REASONFORNONCOMPLIANCE_BINDING);
            protocolMarshaller.marshall(auditFinding.reasonForNonComplianceCode(), REASONFORNONCOMPLIANCECODE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
