/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AuditFinding JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AuditFindingUnmarshaller implements Unmarshaller<AuditFinding, JsonUnmarshallerContext> {

    public AuditFinding unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuditFinding.Builder auditFindingBuilder = AuditFinding.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("taskId", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.taskId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("checkName", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.checkName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("taskStartTime", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.taskStartTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("findingTime", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.findingTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("severity", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.severity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("nonCompliantResource", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.nonCompliantResource(NonCompliantResourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("relatedResources", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.relatedResources(new ListUnmarshaller<RelatedResource>(RelatedResourceUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("reasonForNonCompliance", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.reasonForNonCompliance(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("reasonForNonComplianceCode", targetDepth)) {
                    context.nextToken();
                    auditFindingBuilder.reasonForNonComplianceCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return auditFindingBuilder.build();
    }

    private static final AuditFindingUnmarshaller INSTANCE = new AuditFindingUnmarshaller();

    public static AuditFindingUnmarshaller getInstance() {
        return INSTANCE;
    }
}
