/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AuditTaskMetadata JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AuditTaskMetadataUnmarshaller implements Unmarshaller<AuditTaskMetadata, JsonUnmarshallerContext> {

    public AuditTaskMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuditTaskMetadata.Builder auditTaskMetadataBuilder = AuditTaskMetadata.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("taskId", targetDepth)) {
                    context.nextToken();
                    auditTaskMetadataBuilder.taskId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("taskStatus", targetDepth)) {
                    context.nextToken();
                    auditTaskMetadataBuilder.taskStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("taskType", targetDepth)) {
                    context.nextToken();
                    auditTaskMetadataBuilder.taskType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return auditTaskMetadataBuilder.build();
    }

    private static final AuditTaskMetadataUnmarshaller INSTANCE = new AuditTaskMetadataUnmarshaller();

    public static AuditTaskMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}
