/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuthResult;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AuthResult} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AuthResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUTHINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authInfo").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ALLOWED_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowed").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DENIED_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denied").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHDECISION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authDecision").isBinary(false).build();

    private static final MarshallingInfo<List> MISSINGCONTEXTVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missingContextValues").isBinary(false).build();

    private static final AuthResultMarshaller INSTANCE = new AuthResultMarshaller();

    private AuthResultMarshaller() {
    }

    public static AuthResultMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AuthResult authResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(authResult, "authResult");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(authResult.authInfo(), AUTHINFO_BINDING);
            protocolMarshaller.marshall(authResult.allowed(), ALLOWED_BINDING);
            protocolMarshaller.marshall(authResult.denied(), DENIED_BINDING);
            protocolMarshaller.marshall(authResult.authDecisionAsString(), AUTHDECISION_BINDING);
            protocolMarshaller.marshall(authResult.missingContextValues(), MISSINGCONTEXTVALUES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
