/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AuthorizerDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AuthorizerDescriptionUnmarshaller implements Unmarshaller<AuthorizerDescription, JsonUnmarshallerContext> {

    public AuthorizerDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuthorizerDescription.Builder authorizerDescriptionBuilder = AuthorizerDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("authorizerName", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.authorizerName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("authorizerArn", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.authorizerArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("authorizerFunctionArn", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.authorizerFunctionArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("tokenKeyName", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.tokenKeyName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("tokenSigningPublicKeys", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.tokenSigningPublicKeys(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("lastModifiedDate", targetDepth)) {
                    context.nextToken();
                    authorizerDescriptionBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return authorizerDescriptionBuilder.build();
    }

    private static final AuthorizerDescriptionUnmarshaller INSTANCE = new AuthorizerDescriptionUnmarshaller();

    public static AuthorizerDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
