/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateAuthorizerRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateAuthorizerRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHORIZERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("authorizerName").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZERFUNCTIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerFunctionArn").isBinary(false).build();

    private static final MarshallingInfo<String> TOKENKEYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenKeyName").isBinary(false).build();

    private static final MarshallingInfo<Map> TOKENSIGNINGPUBLICKEYS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenSigningPublicKeys").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final CreateAuthorizerRequestModelMarshaller INSTANCE = new CreateAuthorizerRequestModelMarshaller();

    private CreateAuthorizerRequestModelMarshaller() {
    }

    public static CreateAuthorizerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateAuthorizerRequest createAuthorizerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createAuthorizerRequest, "createAuthorizerRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createAuthorizerRequest.authorizerName(), AUTHORIZERNAME_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.authorizerFunctionArn(), AUTHORIZERFUNCTIONARN_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.tokenKeyName(), TOKENKEYNAME_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.tokenSigningPublicKeys(), TOKENSIGNINGPUBLICKEYS_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.statusAsString(), STATUS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
