/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateOtaUpdateRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateOtaUpdateRequestModelMarshaller {
    private static final MarshallingInfo<String> OTAUPDATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("otaUpdateId").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();

    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("awsJobExecutionsRolloutConfig").isBinary(false).build();

    private static final MarshallingInfo<List> FILES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("files").isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();

    private static final MarshallingInfo<Map> ADDITIONALPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalParameters").isBinary(false).build();

    private static final CreateOtaUpdateRequestModelMarshaller INSTANCE = new CreateOtaUpdateRequestModelMarshaller();

    private CreateOtaUpdateRequestModelMarshaller() {
    }

    public static CreateOtaUpdateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateOtaUpdateRequest createOtaUpdateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createOtaUpdateRequest, "createOtaUpdateRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createOtaUpdateRequest.otaUpdateId(), OTAUPDATEID_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.awsJobExecutionsRolloutConfig(),
                    AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.files(), FILES_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(createOtaUpdateRequest.additionalParameters(), ADDITIONALPARAMETERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
