/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateSecurityProfileRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateSecurityProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("securityProfileName").isBinary(false).build();

    private static final MarshallingInfo<String> SECURITYPROFILEDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("securityProfileDescription").isBinary(false).build();

    private static final MarshallingInfo<List> BEHAVIORS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behaviors").isBinary(false).build();

    private static final MarshallingInfo<Map> ALERTTARGETS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alertTargets").isBinary(false).build();

    private static final CreateSecurityProfileRequestModelMarshaller INSTANCE = new CreateSecurityProfileRequestModelMarshaller();

    private CreateSecurityProfileRequestModelMarshaller() {
    }

    public static CreateSecurityProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateSecurityProfileRequest createSecurityProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createSecurityProfileRequest, "createSecurityProfileRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createSecurityProfileRequest.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall(createSecurityProfileRequest.securityProfileDescription(),
                    SECURITYPROFILEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(createSecurityProfileRequest.behaviors(), BEHAVIORS_BINDING);
            protocolMarshaller.marshall(createSecurityProfileRequest.alertTargetsAsStrings(), ALERTTARGETS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
