/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeScheduledAuditResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScheduledAuditResponseUnmarshaller implements
        Unmarshaller<DescribeScheduledAuditResponse, JsonUnmarshallerContext> {

    public DescribeScheduledAuditResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeScheduledAuditResponse.Builder describeScheduledAuditResponseBuilder = DescribeScheduledAuditResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeScheduledAuditResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("frequency", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.frequency(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dayOfMonth", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.dayOfMonth(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dayOfWeek", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.dayOfWeek(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("targetCheckNames", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.targetCheckNames(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("scheduledAuditName", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.scheduledAuditName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("scheduledAuditArn", targetDepth)) {
                    context.nextToken();
                    describeScheduledAuditResponseBuilder.scheduledAuditArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeScheduledAuditResponseBuilder.build();
    }

    private static final DescribeScheduledAuditResponseUnmarshaller INSTANCE = new DescribeScheduledAuditResponseUnmarshaller();

    public static DescribeScheduledAuditResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
