/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeThingRegistrationTaskResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeThingRegistrationTaskResponseUnmarshaller implements
        Unmarshaller<DescribeThingRegistrationTaskResponse, JsonUnmarshallerContext> {

    public DescribeThingRegistrationTaskResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeThingRegistrationTaskResponse.Builder describeThingRegistrationTaskResponseBuilder = DescribeThingRegistrationTaskResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeThingRegistrationTaskResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("taskId", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder
                            .taskId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("lastModifiedDate", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.lastModifiedDate(context
                            .getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("templateBody", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.templateBody(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("inputFileBucket", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.inputFileBucket(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("inputFileKey", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.inputFileKey(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.roleArn(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder
                            .status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.message(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("successCount", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.successCount(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("failureCount", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.failureCount(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("percentageProgress", targetDepth)) {
                    context.nextToken();
                    describeThingRegistrationTaskResponseBuilder.percentageProgress(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeThingRegistrationTaskResponseBuilder.build();
    }

    private static final DescribeThingRegistrationTaskResponseUnmarshaller INSTANCE = new DescribeThingRegistrationTaskResponseUnmarshaller();

    public static DescribeThingRegistrationTaskResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
