/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetEffectivePoliciesRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetEffectivePoliciesRequestModelMarshaller {
    private static final MarshallingInfo<String> PRINCIPAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principal").isBinary(false).build();

    private static final MarshallingInfo<String> COGNITOIDENTITYPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cognitoIdentityPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("thingName").isBinary(false).build();

    private static final GetEffectivePoliciesRequestModelMarshaller INSTANCE = new GetEffectivePoliciesRequestModelMarshaller();

    private GetEffectivePoliciesRequestModelMarshaller() {
    }

    public static GetEffectivePoliciesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetEffectivePoliciesRequest getEffectivePoliciesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getEffectivePoliciesRequest, "getEffectivePoliciesRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getEffectivePoliciesRequest.principal(), PRINCIPAL_BINDING);
            protocolMarshaller.marshall(getEffectivePoliciesRequest.cognitoIdentityPoolId(), COGNITOIDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall(getEffectivePoliciesRequest.thingName(), THINGNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
