/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.JobExecution;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link JobExecution} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class JobExecutionMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<Boolean> FORCECANCELED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forceCanceled").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STATUSDETAILS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusDetails")
            .isBinary(false).build();

    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingArn").isBinary(false).build();

    private static final MarshallingInfo<Instant> QUEUEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queuedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<Long> EXECUTIONNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionNumber").isBinary(false).build();

    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionNumber").isBinary(false).build();

    private static final JobExecutionMarshaller INSTANCE = new JobExecutionMarshaller();

    private JobExecutionMarshaller() {
    }

    public static JobExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(JobExecution jobExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(jobExecution, "jobExecution");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobExecution.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(jobExecution.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(jobExecution.forceCanceled(), FORCECANCELED_BINDING);
            protocolMarshaller.marshall(jobExecution.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall(jobExecution.thingArn(), THINGARN_BINDING);
            protocolMarshaller.marshall(jobExecution.queuedAt(), QUEUEDAT_BINDING);
            protocolMarshaller.marshall(jobExecution.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall(jobExecution.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(jobExecution.executionNumber(), EXECUTIONNUMBER_BINDING);
            protocolMarshaller.marshall(jobExecution.versionNumber(), VERSIONNUMBER_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
