/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Job;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Job} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<String> JOBARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobArn").isBinary(false).build();

    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();

    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<Boolean> FORCECANCELED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forceCanceled").isBinary(false).build();

    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("comment").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PRESIGNEDURLCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("presignedUrlConfig").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> JOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("jobExecutionsRolloutConfig").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> COMPLETEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> JOBPROCESSDETAILS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("jobProcessDetails").isBinary(false).build();

    private static final JobMarshaller INSTANCE = new JobMarshaller();

    private JobMarshaller() {
    }

    public static JobMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(job, "job");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(job.jobArn(), JOBARN_BINDING);
            protocolMarshaller.marshall(job.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(job.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall(job.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(job.forceCanceled(), FORCECANCELED_BINDING);
            protocolMarshaller.marshall(job.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall(job.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(job.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(job.presignedUrlConfig(), PRESIGNEDURLCONFIG_BINDING);
            protocolMarshaller.marshall(job.jobExecutionsRolloutConfig(), JOBEXECUTIONSROLLOUTCONFIG_BINDING);
            protocolMarshaller.marshall(job.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(job.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(job.completedAt(), COMPLETEDAT_BINDING);
            protocolMarshaller.marshall(job.jobProcessDetails(), JOBPROCESSDETAILS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
