/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.JobProcessDetails;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link JobProcessDetails} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class JobProcessDetailsMarshaller {
    private static final MarshallingInfo<List> PROCESSINGTARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("processingTargets").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFCANCELEDTHINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("numberOfCanceledThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFSUCCEEDEDTHINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("numberOfSucceededThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFFAILEDTHINGS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfFailedThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFREJECTEDTHINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("numberOfRejectedThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFQUEUEDTHINGS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfQueuedThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFINPROGRESSTHINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("numberOfInProgressThings").isBinary(false).build();

    private static final MarshallingInfo<Integer> NUMBEROFREMOVEDTHINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("numberOfRemovedThings").isBinary(false).build();

    private static final JobProcessDetailsMarshaller INSTANCE = new JobProcessDetailsMarshaller();

    private JobProcessDetailsMarshaller() {
    }

    public static JobProcessDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(JobProcessDetails jobProcessDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(jobProcessDetails, "jobProcessDetails");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobProcessDetails.processingTargets(), PROCESSINGTARGETS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfCanceledThings(), NUMBEROFCANCELEDTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfSucceededThings(), NUMBEROFSUCCEEDEDTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfFailedThings(), NUMBEROFFAILEDTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfRejectedThings(), NUMBEROFREJECTEDTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfQueuedThings(), NUMBEROFQUEUEDTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfInProgressThings(), NUMBEROFINPROGRESSTHINGS_BINDING);
            protocolMarshaller.marshall(jobProcessDetails.numberOfRemovedThings(), NUMBEROFREMOVEDTHINGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
