/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListActiveViolationsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListActiveViolationsRequestModelMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("thingName").isBinary(false).build();

    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("securityProfileName").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("nextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("maxResults").isBinary(false).build();

    private static final ListActiveViolationsRequestModelMarshaller INSTANCE = new ListActiveViolationsRequestModelMarshaller();

    private ListActiveViolationsRequestModelMarshaller() {
    }

    public static ListActiveViolationsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListActiveViolationsRequest listActiveViolationsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listActiveViolationsRequest, "listActiveViolationsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listActiveViolationsRequest.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall(listActiveViolationsRequest.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall(listActiveViolationsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listActiveViolationsRequest.maxResults(), MAXRESULTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
