/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListAuditTasksRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListAuditTasksRequestModelMarshaller {
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("startTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("endTime").isBinary(false).build();

    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("taskType").isBinary(false).build();

    private static final MarshallingInfo<String> TASKSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("taskStatus").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("nextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("maxResults").isBinary(false).build();

    private static final ListAuditTasksRequestModelMarshaller INSTANCE = new ListAuditTasksRequestModelMarshaller();

    private ListAuditTasksRequestModelMarshaller() {
    }

    public static ListAuditTasksRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListAuditTasksRequest listAuditTasksRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listAuditTasksRequest, "listAuditTasksRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listAuditTasksRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(listAuditTasksRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(listAuditTasksRequest.taskTypeAsString(), TASKTYPE_BINDING);
            protocolMarshaller.marshall(listAuditTasksRequest.taskStatusAsString(), TASKSTATUS_BINDING);
            protocolMarshaller.marshall(listAuditTasksRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listAuditTasksRequest.maxResults(), MAXRESULTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
