/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link OTAUpdateFile} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OTAUpdateFileMarshaller {
    private static final MarshallingInfo<String> FILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileName").isBinary(false).build();

    private static final MarshallingInfo<String> FILEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileVersion").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> FILELOCATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileLocation")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CODESIGNING_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codeSigning")
            .isBinary(false).build();

    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();

    private static final OTAUpdateFileMarshaller INSTANCE = new OTAUpdateFileMarshaller();

    private OTAUpdateFileMarshaller() {
    }

    public static OTAUpdateFileMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(OTAUpdateFile otaUpdateFile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(otaUpdateFile, "otaUpdateFile");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(otaUpdateFile.fileName(), FILENAME_BINDING);
            protocolMarshaller.marshall(otaUpdateFile.fileVersion(), FILEVERSION_BINDING);
            protocolMarshaller.marshall(otaUpdateFile.fileLocation(), FILELOCATION_BINDING);
            protocolMarshaller.marshall(otaUpdateFile.codeSigning(), CODESIGNING_BINDING);
            protocolMarshaller.marshall(otaUpdateFile.attributes(), ATTRIBUTES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
