/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.OTAUpdateInfo;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link OTAUpdateInfo} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OTAUpdateInfoMarshaller {
    private static final MarshallingInfo<String> OTAUPDATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateId").isBinary(false).build();

    private static final MarshallingInfo<String> OTAUPDATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateArn").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("awsJobExecutionsRolloutConfig").isBinary(false).build();

    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();

    private static final MarshallingInfo<List> OTAUPDATEFILES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateFiles").isBinary(false).build();

    private static final MarshallingInfo<String> OTAUPDATESTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("otaUpdateStatus").isBinary(false).build();

    private static final MarshallingInfo<String> AWSIOTJOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotJobId").isBinary(false).build();

    private static final MarshallingInfo<String> AWSIOTJOBARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotJobArn").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInfo").isBinary(false).build();

    private static final MarshallingInfo<Map> ADDITIONALPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalParameters").isBinary(false).build();

    private static final OTAUpdateInfoMarshaller INSTANCE = new OTAUpdateInfoMarshaller();

    private OTAUpdateInfoMarshaller() {
    }

    public static OTAUpdateInfoMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(OTAUpdateInfo otaUpdateInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(otaUpdateInfo, "otaUpdateInfo");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(otaUpdateInfo.otaUpdateId(), OTAUPDATEID_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.otaUpdateArn(), OTAUPDATEARN_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.awsJobExecutionsRolloutConfig(), AWSJOBEXECUTIONSROLLOUTCONFIG_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.otaUpdateFiles(), OTAUPDATEFILES_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.otaUpdateStatusAsString(), OTAUPDATESTATUS_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.awsIotJobId(), AWSIOTJOBID_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.awsIotJobArn(), AWSIOTJOBARN_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.errorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall(otaUpdateInfo.additionalParameters(), ADDITIONALPARAMETERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
