/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * OTAUpdateInfo JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class OTAUpdateInfoUnmarshaller implements Unmarshaller<OTAUpdateInfo, JsonUnmarshallerContext> {

    public OTAUpdateInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        OTAUpdateInfo.Builder otaUpdateInfoBuilder = OTAUpdateInfo.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("otaUpdateId", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.otaUpdateId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("otaUpdateArn", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.otaUpdateArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("lastModifiedDate", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("targets", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.targets(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("awsJobExecutionsRolloutConfig", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfigUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("targetSelection", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.targetSelection(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("otaUpdateFiles", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.otaUpdateFiles(new ListUnmarshaller<OTAUpdateFile>(OTAUpdateFileUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("otaUpdateStatus", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.otaUpdateStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("awsIotJobId", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.awsIotJobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("awsIotJobArn", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.awsIotJobArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("errorInfo", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.errorInfo(ErrorInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("additionalParameters", targetDepth)) {
                    context.nextToken();
                    otaUpdateInfoBuilder.additionalParameters(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return otaUpdateInfoBuilder.build();
    }

    private static final OTAUpdateInfoUnmarshaller INSTANCE = new OTAUpdateInfoUnmarshaller();

    public static OTAUpdateInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}
