/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ScheduledAuditMetadata} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ScheduledAuditMetadataMarshaller {
    private static final MarshallingInfo<String> SCHEDULEDAUDITNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduledAuditName").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEDULEDAUDITARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduledAuditArn").isBinary(false).build();

    private static final MarshallingInfo<String> FREQUENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").isBinary(false).build();

    private static final MarshallingInfo<String> DAYOFMONTH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfMonth").isBinary(false).build();

    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfWeek").isBinary(false).build();

    private static final ScheduledAuditMetadataMarshaller INSTANCE = new ScheduledAuditMetadataMarshaller();

    private ScheduledAuditMetadataMarshaller() {
    }

    public static ScheduledAuditMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ScheduledAuditMetadata scheduledAuditMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(scheduledAuditMetadata, "scheduledAuditMetadata");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(scheduledAuditMetadata.scheduledAuditName(), SCHEDULEDAUDITNAME_BINDING);
            protocolMarshaller.marshall(scheduledAuditMetadata.scheduledAuditArn(), SCHEDULEDAUDITARN_BINDING);
            protocolMarshaller.marshall(scheduledAuditMetadata.frequencyAsString(), FREQUENCY_BINDING);
            protocolMarshaller.marshall(scheduledAuditMetadata.dayOfMonth(), DAYOFMONTH_BINDING);
            protocolMarshaller.marshall(scheduledAuditMetadata.dayOfWeekAsString(), DAYOFWEEK_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
