/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SetV2LoggingOptionsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SetV2LoggingOptionsRequestModelMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTLOGLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultLogLevel").isBinary(false).build();

    private static final MarshallingInfo<Boolean> DISABLEALLLOGS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disableAllLogs").isBinary(false).build();

    private static final SetV2LoggingOptionsRequestModelMarshaller INSTANCE = new SetV2LoggingOptionsRequestModelMarshaller();

    private SetV2LoggingOptionsRequestModelMarshaller() {
    }

    public static SetV2LoggingOptionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SetV2LoggingOptionsRequest setV2LoggingOptionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(setV2LoggingOptionsRequest, "setV2LoggingOptionsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(setV2LoggingOptionsRequest.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(setV2LoggingOptionsRequest.defaultLogLevelAsString(), DEFAULTLOGLEVEL_BINDING);
            protocolMarshaller.marshall(setV2LoggingOptionsRequest.disableAllLogs(), DISABLEALLLOGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
