/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SigningProfileParameter;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SigningProfileParameter} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SigningProfileParameterMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEPATHONDEVICE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("certificatePathOnDevice").isBinary(false).build();

    private static final SigningProfileParameterMarshaller INSTANCE = new SigningProfileParameterMarshaller();

    private SigningProfileParameterMarshaller() {
    }

    public static SigningProfileParameterMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SigningProfileParameter signingProfileParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(signingProfileParameter, "signingProfileParameter");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(signingProfileParameter.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(signingProfileParameter.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(signingProfileParameter.certificatePathOnDevice(), CERTIFICATEPATHONDEVICE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
