/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TaskStatistics;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TaskStatistics} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TaskStatisticsMarshaller {
    private static final MarshallingInfo<Integer> TOTALCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> INPROGRESSCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inProgressChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> WAITINGFORDATACOLLECTIONCHECKS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("waitingForDataCollectionChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> COMPLIANTCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("compliantChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> NONCOMPLIANTCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> FAILEDCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failedChecks").isBinary(false).build();

    private static final MarshallingInfo<Integer> CANCELEDCHECKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canceledChecks").isBinary(false).build();

    private static final TaskStatisticsMarshaller INSTANCE = new TaskStatisticsMarshaller();

    private TaskStatisticsMarshaller() {
    }

    public static TaskStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TaskStatistics taskStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(taskStatistics, "taskStatistics");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(taskStatistics.totalChecks(), TOTALCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.inProgressChecks(), INPROGRESSCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.waitingForDataCollectionChecks(), WAITINGFORDATACOLLECTIONCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.compliantChecks(), COMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.nonCompliantChecks(), NONCOMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.failedChecks(), FAILEDCHECKS_BINDING);
            protocolMarshaller.marshall(taskStatistics.canceledChecks(), CANCELEDCHECKS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
