/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TestAuthorizationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TestAuthorizationRequestModelMarshaller {
    private static final MarshallingInfo<String> PRINCIPAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principal").isBinary(false).build();

    private static final MarshallingInfo<String> COGNITOIDENTITYPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cognitoIdentityPoolId").isBinary(false).build();

    private static final MarshallingInfo<List> AUTHINFOS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authInfos").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("clientId").isBinary(false).build();

    private static final MarshallingInfo<List> POLICYNAMESTOADD_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyNamesToAdd").isBinary(false).build();

    private static final MarshallingInfo<List> POLICYNAMESTOSKIP_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyNamesToSkip").isBinary(false).build();

    private static final TestAuthorizationRequestModelMarshaller INSTANCE = new TestAuthorizationRequestModelMarshaller();

    private TestAuthorizationRequestModelMarshaller() {
    }

    public static TestAuthorizationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TestAuthorizationRequest testAuthorizationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(testAuthorizationRequest, "testAuthorizationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(testAuthorizationRequest.principal(), PRINCIPAL_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.cognitoIdentityPoolId(), COGNITOIDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.authInfos(), AUTHINFOS_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.policyNamesToAdd(), POLICYNAMESTOADD_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.policyNamesToSkip(), POLICYNAMESTOSKIP_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
