/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link TestInvokeAuthorizerRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TestInvokeAuthorizerRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHORIZERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("authorizerName").isBinary(false).build();

    private static final MarshallingInfo<String> TOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("token").isBinary(false).build();

    private static final MarshallingInfo<String> TOKENSIGNATURE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenSignature").isBinary(false).build();

    private static final TestInvokeAuthorizerRequestModelMarshaller INSTANCE = new TestInvokeAuthorizerRequestModelMarshaller();

    private TestInvokeAuthorizerRequestModelMarshaller() {
    }

    public static TestInvokeAuthorizerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(testInvokeAuthorizerRequest, "testInvokeAuthorizerRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.authorizerName(), AUTHORIZERNAME_BINDING);
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.token(), TOKEN_BINDING);
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.tokenSignature(), TOKENSIGNATURE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
