/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TestInvokeAuthorizerResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TestInvokeAuthorizerResponseUnmarshaller implements
        Unmarshaller<TestInvokeAuthorizerResponse, JsonUnmarshallerContext> {

    public TestInvokeAuthorizerResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        TestInvokeAuthorizerResponse.Builder testInvokeAuthorizerResponseBuilder = TestInvokeAuthorizerResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return testInvokeAuthorizerResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("isAuthenticated", targetDepth)) {
                    context.nextToken();
                    testInvokeAuthorizerResponseBuilder.isAuthenticated(context.getUnmarshaller(Boolean.class)
                            .unmarshall(context));
                }
                if (context.testExpression("principalId", targetDepth)) {
                    context.nextToken();
                    testInvokeAuthorizerResponseBuilder.principalId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("policyDocuments", targetDepth)) {
                    context.nextToken();
                    testInvokeAuthorizerResponseBuilder.policyDocuments(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("refreshAfterInSeconds", targetDepth)) {
                    context.nextToken();
                    testInvokeAuthorizerResponseBuilder.refreshAfterInSeconds(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("disconnectAfterInSeconds", targetDepth)) {
                    context.nextToken();
                    testInvokeAuthorizerResponseBuilder.disconnectAfterInSeconds(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return testInvokeAuthorizerResponseBuilder.build();
    }

    private static final TestInvokeAuthorizerResponseUnmarshaller INSTANCE = new TestInvokeAuthorizerResponseUnmarshaller();

    public static TestInvokeAuthorizerResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
