/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingDocument;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ThingDocument} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ThingDocumentMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();

    private static final MarshallingInfo<String> THINGID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingId").isBinary(false).build();

    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").isBinary(false).build();

    private static final MarshallingInfo<List> THINGGROUPNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupNames").isBinary(false).build();

    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();

    private static final MarshallingInfo<String> SHADOW_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shadow").isBinary(false).build();

    private static final ThingDocumentMarshaller INSTANCE = new ThingDocumentMarshaller();

    private ThingDocumentMarshaller() {
    }

    public static ThingDocumentMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ThingDocument thingDocument, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(thingDocument, "thingDocument");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(thingDocument.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall(thingDocument.thingId(), THINGID_BINDING);
            protocolMarshaller.marshall(thingDocument.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall(thingDocument.thingGroupNames(), THINGGROUPNAMES_BINDING);
            protocolMarshaller.marshall(thingDocument.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(thingDocument.shadow(), SHADOW_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
