/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateCaCertificateRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateCaCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("caCertificateId").isBinary(false).build();

    private static final MarshallingInfo<String> NEWSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("newStatus").isBinary(false).build();

    private static final MarshallingInfo<String> NEWAUTOREGISTRATIONSTATUS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM)
            .marshallLocationName("newAutoRegistrationStatus").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REGISTRATIONCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("registrationConfig").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REMOVEAUTOREGISTRATION_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("removeAutoRegistration").isBinary(false).build();

    private static final UpdateCaCertificateRequestModelMarshaller INSTANCE = new UpdateCaCertificateRequestModelMarshaller();

    private UpdateCaCertificateRequestModelMarshaller() {
    }

    public static UpdateCaCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateCaCertificateRequest updateCaCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateCaCertificateRequest, "updateCaCertificateRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateCaCertificateRequest.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall(updateCaCertificateRequest.newStatusAsString(), NEWSTATUS_BINDING);
            protocolMarshaller.marshall(updateCaCertificateRequest.newAutoRegistrationStatusAsString(),
                    NEWAUTOREGISTRATIONSTATUS_BINDING);
            protocolMarshaller.marshall(updateCaCertificateRequest.registrationConfig(), REGISTRATIONCONFIG_BINDING);
            protocolMarshaller.marshall(updateCaCertificateRequest.removeAutoRegistration(), REMOVEAUTOREGISTRATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
