/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateScheduledAuditRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateScheduledAuditRequestModelMarshaller {
    private static final MarshallingInfo<String> FREQUENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").isBinary(false).build();

    private static final MarshallingInfo<String> DAYOFMONTH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfMonth").isBinary(false).build();

    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfWeek").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETCHECKNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetCheckNames").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEDULEDAUDITNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("scheduledAuditName").isBinary(false).build();

    private static final UpdateScheduledAuditRequestModelMarshaller INSTANCE = new UpdateScheduledAuditRequestModelMarshaller();

    private UpdateScheduledAuditRequestModelMarshaller() {
    }

    public static UpdateScheduledAuditRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateScheduledAuditRequest updateScheduledAuditRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateScheduledAuditRequest, "updateScheduledAuditRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateScheduledAuditRequest.frequencyAsString(), FREQUENCY_BINDING);
            protocolMarshaller.marshall(updateScheduledAuditRequest.dayOfMonth(), DAYOFMONTH_BINDING);
            protocolMarshaller.marshall(updateScheduledAuditRequest.dayOfWeekAsString(), DAYOFWEEK_BINDING);
            protocolMarshaller.marshall(updateScheduledAuditRequest.targetCheckNames(), TARGETCHECKNAMES_BINDING);
            protocolMarshaller.marshall(updateScheduledAuditRequest.scheduledAuditName(), SCHEDULEDAUDITNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
