/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateSecurityProfileResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateSecurityProfileResponseUnmarshaller implements
        Unmarshaller<UpdateSecurityProfileResponse, JsonUnmarshallerContext> {

    public UpdateSecurityProfileResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateSecurityProfileResponse.Builder updateSecurityProfileResponseBuilder = UpdateSecurityProfileResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateSecurityProfileResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("securityProfileName", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.securityProfileName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("securityProfileArn", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.securityProfileArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("securityProfileDescription", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.securityProfileDescription(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("behaviors", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.behaviors(new ListUnmarshaller<Behavior>(BehaviorUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("alertTargets", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.alertTargetsWithStrings(new MapUnmarshaller<String, AlertTarget>(context
                            .getUnmarshaller(String.class), AlertTargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.version(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("lastModifiedDate", targetDepth)) {
                    context.nextToken();
                    updateSecurityProfileResponseBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateSecurityProfileResponseBuilder.build();
    }

    private static final UpdateSecurityProfileResponseUnmarshaller INSTANCE = new UpdateSecurityProfileResponseUnmarshaller();

    public static UpdateSecurityProfileResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
