/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ViolationEvent;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ViolationEvent} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ViolationEventMarshaller {
    private static final MarshallingInfo<String> VIOLATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationId").isBinary(false).build();

    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();

    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behavior").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> METRICVALUE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue")
            .isBinary(false).build();

    private static final MarshallingInfo<String> VIOLATIONEVENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventType").isBinary(false).build();

    private static final MarshallingInfo<Instant> VIOLATIONEVENTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventTime").isBinary(false).build();

    private static final ViolationEventMarshaller INSTANCE = new ViolationEventMarshaller();

    private ViolationEventMarshaller() {
    }

    public static ViolationEventMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ViolationEvent violationEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(violationEvent, "violationEvent");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(violationEvent.violationId(), VIOLATIONID_BINDING);
            protocolMarshaller.marshall(violationEvent.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall(violationEvent.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall(violationEvent.behavior(), BEHAVIOR_BINDING);
            protocolMarshaller.marshall(violationEvent.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall(violationEvent.violationEventTypeAsString(), VIOLATIONEVENTTYPE_BINDING);
            protocolMarshaller.marshall(violationEvent.violationEventTime(), VIOLATIONEVENTTIME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
