/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuditTaskStatus;
import software.amazon.awssdk.services.iot.model.AuditTaskType;
import software.amazon.awssdk.services.iot.transform.AuditTaskMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditTaskMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, AuditTaskMetadata> {
    private final String taskId;
    private final String taskStatus;
    private final String taskType;

    private AuditTaskMetadata(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.taskType = builder.taskType;
    }

    public String taskId() {
        return this.taskId;
    }

    public AuditTaskStatus taskStatus() {
        return AuditTaskStatus.fromValue(this.taskStatus);
    }

    public String taskStatusAsString() {
        return this.taskStatus;
    }

    public AuditTaskType taskType() {
        return AuditTaskType.fromValue(this.taskType);
    }

    public String taskTypeAsString() {
        return this.taskType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditTaskMetadata)) {
            return false;
        }
        AuditTaskMetadata other = (AuditTaskMetadata)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AuditTaskMetadata").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("TaskType", (Object)this.taskTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "taskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditTaskMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String taskType;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditTaskMetadata model) {
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.taskType(model.taskType);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditTaskStatus taskStatus) {
            this.taskStatus(taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(AuditTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public AuditTaskMetadata build() {
            return new AuditTaskMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuditTaskMetadata> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(AuditTaskStatus var1);

        public Builder taskType(String var1);

        public Builder taskType(AuditTaskType var1);
    }
}

