/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.BehaviorCriteria;
import software.amazon.awssdk.services.iot.transform.BehaviorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Behavior
implements StructuredPojo,
ToCopyableBuilder<Builder, Behavior> {
    private final String name;
    private final String metric;
    private final BehaviorCriteria criteria;

    private Behavior(BuilderImpl builder) {
        this.name = builder.name;
        this.metric = builder.metric;
        this.criteria = builder.criteria;
    }

    public String name() {
        return this.name;
    }

    public String metric() {
        return this.metric;
    }

    public BehaviorCriteria criteria() {
        return this.criteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Behavior)) {
            return false;
        }
        Behavior other = (Behavior)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.criteria(), other.criteria());
    }

    public String toString() {
        return ToString.builder((String)"Behavior").add("Name", (Object)this.name()).add("Metric", (Object)this.metric()).add("Criteria", (Object)this.criteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BehaviorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String metric;
        private BehaviorCriteria criteria;

        private BuilderImpl() {
        }

        private BuilderImpl(Behavior model) {
            this.name(model.name);
            this.metric(model.metric);
            this.criteria(model.criteria);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetric() {
            return this.metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final BehaviorCriteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        @Override
        public final Builder criteria(BehaviorCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final void setCriteria(BehaviorCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        public Behavior build() {
            return new Behavior(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Behavior> {
        public Builder name(String var1);

        public Builder metric(String var1);

        public Builder criteria(BehaviorCriteria var1);

        default public Builder criteria(Consumer<BehaviorCriteria.Builder> criteria) {
            return this.criteria((BehaviorCriteria)((BehaviorCriteria.Builder)BehaviorCriteria.builder().applyMutation(criteria)).build());
        }
    }
}

