/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CodeSigningSignatureMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSigningSignature
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeSigningSignature> {
    private final SdkBytes inlineDocument;

    private CodeSigningSignature(BuilderImpl builder) {
        this.inlineDocument = builder.inlineDocument;
    }

    public SdkBytes inlineDocument() {
        return this.inlineDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineDocument());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningSignature)) {
            return false;
        }
        CodeSigningSignature other = (CodeSigningSignature)obj;
        return Objects.equals(this.inlineDocument(), other.inlineDocument());
    }

    public String toString() {
        return ToString.builder((String)"CodeSigningSignature").add("InlineDocument", (Object)this.inlineDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inlineDocument": {
                return Optional.ofNullable(clazz.cast(this.inlineDocument()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningSignatureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes inlineDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningSignature model) {
            this.inlineDocument(model.inlineDocument);
        }

        public final ByteBuffer getInlineDocument() {
            return this.inlineDocument == null ? null : this.inlineDocument.asByteBuffer();
        }

        @Override
        public final Builder inlineDocument(SdkBytes inlineDocument) {
            this.inlineDocument = StandardMemberCopier.copy((SdkBytes)inlineDocument);
            return this;
        }

        public final void setInlineDocument(ByteBuffer inlineDocument) {
            this.inlineDocument(inlineDocument == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)inlineDocument));
        }

        public CodeSigningSignature build() {
            return new CodeSigningSignature(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeSigningSignature> {
        public Builder inlineDocument(SdkBytes var1);
    }
}

